package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConflictResolution(
    replaceContents: Option[
      Iterable[zio.aws.codecommit.model.ReplaceContentEntry]
    ] = None,
    deleteFiles: Option[Iterable[zio.aws.codecommit.model.DeleteFileEntry]] =
      None,
    setFileModes: Option[Iterable[zio.aws.codecommit.model.SetFileModeEntry]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ConflictResolution = {
    import ConflictResolution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ConflictResolution
      .builder()
      .optionallyWith(
        replaceContents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replaceContents)
      .optionallyWith(
        deleteFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteFiles)
      .optionallyWith(
        setFileModes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.setFileModes)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ConflictResolution.ReadOnly =
    zio.aws.codecommit.model.ConflictResolution.wrap(buildAwsValue())
}
object ConflictResolution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ConflictResolution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ConflictResolution =
      zio.aws.codecommit.model.ConflictResolution(
        replaceContents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        setFileModes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replaceContents
        : Option[List[zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly]]
    def deleteFiles
        : Option[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]]
    def setFileModes
        : Option[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]]
    def getReplaceContents: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("replaceContents", replaceContents)
    def getDeleteFiles: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.DeleteFileEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteFiles", deleteFiles)
    def getSetFileModes: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.SetFileModeEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("setFileModes", setFileModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictResolution
  ) extends zio.aws.codecommit.model.ConflictResolution.ReadOnly {
    override val replaceContents
        : Option[List[zio.aws.codecommit.model.ReplaceContentEntry.ReadOnly]] =
      scala
        .Option(impl.replaceContents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.ReplaceContentEntry.wrap(item)
          }.toList
        )
    override val deleteFiles
        : Option[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]] =
      scala
        .Option(impl.deleteFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.DeleteFileEntry.wrap(item)
          }.toList
        )
    override val setFileModes
        : Option[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]] =
      scala
        .Option(impl.setFileModes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.SetFileModeEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ConflictResolution
  ): zio.aws.codecommit.model.ConflictResolution.ReadOnly = new Wrapper(impl)
}
