package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetRepositoryRequest(repositoryName: RepositoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest = {
    import GetRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.GetRepositoryRequest.wrap(buildAwsValue())
}
object GetRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetRepositoryRequest =
      zio.aws.codecommit.model.GetRepositoryRequest(repositoryName)
    def repositoryName: RepositoryName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest
  ) extends zio.aws.codecommit.model.GetRepositoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest
  ): zio.aws.codecommit.model.GetRepositoryRequest.ReadOnly = new Wrapper(impl)
}
