package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFileCommitHistoryResponse(
    revisionDag: Iterable[zio.aws.codecommit.model.FileVersion],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse = {
    import ListFileCommitHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse
      .builder()
      .revisionDag(revisionDag.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListFileCommitHistoryResponse.ReadOnly =
    zio.aws.codecommit.model.ListFileCommitHistoryResponse.wrap(buildAwsValue())
}
object ListFileCommitHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListFileCommitHistoryResponse =
      zio.aws.codecommit.model.ListFileCommitHistoryResponse(
        revisionDag.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def revisionDag: List[zio.aws.codecommit.model.FileVersion.ReadOnly]
    def nextToken: Optional[NextToken]
    def getRevisionDag: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.FileVersion.ReadOnly
    ]] = ZIO.succeed(revisionDag)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse
  ) extends zio.aws.codecommit.model.ListFileCommitHistoryResponse.ReadOnly {
    override val revisionDag
        : List[zio.aws.codecommit.model.FileVersion.ReadOnly] = impl
      .revisionDag()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.FileVersion.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse
  ): zio.aws.codecommit.model.ListFileCommitHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
