package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.CapitalBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IsBinaryFile(
    source: Optional[CapitalBoolean] = Optional.Absent,
    destination: Optional[CapitalBoolean] = Optional.Absent,
    base: Optional[CapitalBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.IsBinaryFile = {
    import IsBinaryFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.IsBinaryFile
      .builder()
      .optionallyWith(
        source.map(value => CapitalBoolean.unwrap(value): java.lang.Boolean)
      )(_.source)
      .optionallyWith(
        destination.map(value =>
          CapitalBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.destination)
      .optionallyWith(
        base.map(value => CapitalBoolean.unwrap(value): java.lang.Boolean)
      )(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.IsBinaryFile.ReadOnly =
    zio.aws.codecommit.model.IsBinaryFile.wrap(buildAwsValue())
}
object IsBinaryFile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.IsBinaryFile =
      zio.aws.codecommit.model.IsBinaryFile(
        source.map(value => value),
        destination.map(value => value),
        base.map(value => value)
      )
    def source: Optional[CapitalBoolean]
    def destination: Optional[CapitalBoolean]
    def base: Optional[CapitalBoolean]
    def getSource: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ) extends zio.aws.codecommit.model.IsBinaryFile.ReadOnly {
    override val source: Optional[CapitalBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
    override val destination: Optional[CapitalBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
    override val base: Optional[CapitalBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.base())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ): zio.aws.codecommit.model.IsBinaryFile.ReadOnly = new Wrapper(impl)
}
