package zio.aws.codecommit.model
import scala.jdk.CollectionConverters._
sealed trait OrderEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.OrderEnum
}
object OrderEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.OrderEnum
  ): zio.aws.codecommit.model.OrderEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.OrderEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.OrderEnum.ASCENDING =>
      val r = ascending
      r
    case software.amazon.awssdk.services.codecommit.model.OrderEnum.DESCENDING =>
      val r = descending
      r
  }
  case object unknownToSdkVersion extends zio.aws.codecommit.model.OrderEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OrderEnum =
      software.amazon.awssdk.services.codecommit.model.OrderEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ascending extends zio.aws.codecommit.model.OrderEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OrderEnum =
      software.amazon.awssdk.services.codecommit.model.OrderEnum.ASCENDING
  }
  case object descending extends zio.aws.codecommit.model.OrderEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.OrderEnum =
      software.amazon.awssdk.services.codecommit.model.OrderEnum.DESCENDING
  }
}
