package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Folder(
    treeId: Optional[ObjectId] = Optional.Absent,
    absolutePath: Optional[Path] = Optional.Absent,
    relativePath: Optional[Path] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Folder = {
    import Folder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Folder
      .builder()
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        relativePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.relativePath)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Folder.ReadOnly =
    zio.aws.codecommit.model.Folder.wrap(buildAwsValue())
}
object Folder {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codecommit.model.Folder] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Folder =
      zio.aws.codecommit.model.Folder(
        treeId.map(value => value),
        absolutePath.map(value => value),
        relativePath.map(value => value)
      )
    def treeId: Optional[ObjectId]
    def absolutePath: Optional[Path]
    def relativePath: Optional[Path]
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getRelativePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("relativePath", relativePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Folder
  ) extends zio.aws.codecommit.model.Folder.ReadOnly {
    override val treeId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val absolutePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val relativePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.relativePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Folder
  ): zio.aws.codecommit.model.Folder.ReadOnly = new Wrapper(impl)
}
