package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleTemplateDescription,
  ApprovalRuleTemplateName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateApprovalRuleTemplateDescriptionRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    approvalRuleTemplateDescription: ApprovalRuleTemplateDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest = {
    import UpdateApprovalRuleTemplateDescriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .approvalRuleTemplateDescription(
        ApprovalRuleTemplateDescription.unwrap(
          approvalRuleTemplateDescription
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
      .wrap(buildAwsValue())
}
object UpdateApprovalRuleTemplateDescriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest =
      zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest(
        approvalRuleTemplateName,
        approvalRuleTemplateDescription
      )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def approvalRuleTemplateDescription: ApprovalRuleTemplateDescription
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getApprovalRuleTemplateDescription
        : ZIO[Any, Nothing, ApprovalRuleTemplateDescription] =
      ZIO.succeed(approvalRuleTemplateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
  ) extends zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val approvalRuleTemplateDescription
        : ApprovalRuleTemplateDescription = zio.aws.codecommit.model.primitives
      .ApprovalRuleTemplateDescription(impl.approvalRuleTemplateDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest
  ): zio.aws.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest.ReadOnly =
    new Wrapper(impl)
}
