package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{RevisionId, PullRequestId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPullRequestOverrideStateRequest(
    pullRequestId: PullRequestId,
    revisionId: RevisionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest = {
    import GetPullRequestOverrideStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .revisionId(RevisionId.unwrap(revisionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetPullRequestOverrideStateRequest.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestOverrideStateRequest
      .wrap(buildAwsValue())
}
object GetPullRequestOverrideStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetPullRequestOverrideStateRequest =
      zio.aws.codecommit.model
        .GetPullRequestOverrideStateRequest(pullRequestId, revisionId)
    def pullRequestId: PullRequestId
    def revisionId: RevisionId
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRevisionId: ZIO[Any, Nothing, RevisionId] = ZIO.succeed(revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest
  ) extends zio.aws.codecommit.model.GetPullRequestOverrideStateRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val revisionId: RevisionId =
      zio.aws.codecommit.model.primitives.RevisionId(impl.revisionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest
  ): zio.aws.codecommit.model.GetPullRequestOverrideStateRequest.ReadOnly =
    new Wrapper(impl)
}
