package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Content, CommentId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateCommentRequest(commentId: CommentId, content: Content) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest = {
    import UpdateCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest
      .builder()
      .commentId(CommentId.unwrap(commentId): java.lang.String)
      .content(Content.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.UpdateCommentRequest.ReadOnly =
    zio.aws.codecommit.model.UpdateCommentRequest.wrap(buildAwsValue())
}
object UpdateCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdateCommentRequest =
      zio.aws.codecommit.model.UpdateCommentRequest(commentId, content)
    def commentId: CommentId
    def content: Content
    def getCommentId: ZIO[Any, Nothing, CommentId] = ZIO.succeed(commentId)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest
  ) extends zio.aws.codecommit.model.UpdateCommentRequest.ReadOnly {
    override val commentId: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.commentId())
    override val content: Content =
      zio.aws.codecommit.model.primitives.Content(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest
  ): zio.aws.codecommit.model.UpdateCommentRequest.ReadOnly = new Wrapper(impl)
}
