package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCommitResponse(
    commitId: Optional[ObjectId] = Optional.Absent,
    treeId: Optional[ObjectId] = Optional.Absent,
    filesAdded: Optional[Iterable[zio.aws.codecommit.model.FileMetadata]] =
      Optional.Absent,
    filesUpdated: Optional[Iterable[zio.aws.codecommit.model.FileMetadata]] =
      Optional.Absent,
    filesDeleted: Optional[Iterable[zio.aws.codecommit.model.FileMetadata]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateCommitResponse = {
    import CreateCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        filesAdded.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesAdded)
      .optionallyWith(
        filesUpdated.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesUpdated)
      .optionallyWith(
        filesDeleted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesDeleted)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateCommitResponse.ReadOnly =
    zio.aws.codecommit.model.CreateCommitResponse.wrap(buildAwsValue())
}
object CreateCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateCommitResponse =
      zio.aws.codecommit.model.CreateCommitResponse(
        commitId.map(value => value),
        treeId.map(value => value),
        filesAdded.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filesUpdated.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filesDeleted.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def commitId: Optional[ObjectId]
    def treeId: Optional[ObjectId]
    def filesAdded
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def filesUpdated
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def filesDeleted
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getFilesAdded: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesAdded", filesAdded)
    def getFilesUpdated: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesUpdated", filesUpdated)
    def getFilesDeleted: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesDeleted", filesDeleted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ) extends zio.aws.codecommit.model.CreateCommitResponse.ReadOnly {
    override val commitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val filesAdded
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filesAdded())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.FileMetadata.wrap(item)
          }.toList
        )
    override val filesUpdated
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filesUpdated())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.FileMetadata.wrap(item)
          }.toList
        )
    override val filesDeleted
        : Optional[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filesDeleted())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.FileMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ): zio.aws.codecommit.model.CreateCommitResponse.ReadOnly = new Wrapper(impl)
}
