package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  ReferenceName,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PullRequestTarget(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    sourceReference: Optional[ReferenceName] = Optional.Absent,
    destinationReference: Optional[ReferenceName] = Optional.Absent,
    destinationCommit: Optional[CommitId] = Optional.Absent,
    sourceCommit: Optional[CommitId] = Optional.Absent,
    mergeBase: Optional[CommitId] = Optional.Absent,
    mergeMetadata: Optional[zio.aws.codecommit.model.MergeMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestTarget = {
    import PullRequestTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestTarget
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        sourceReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.sourceReference)
      .optionallyWith(
        destinationReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.destinationReference)
      .optionallyWith(
        destinationCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.destinationCommit)
      .optionallyWith(
        sourceCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.sourceCommit)
      .optionallyWith(
        mergeBase.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBase)
      .optionallyWith(mergeMetadata.map(value => value.buildAwsValue()))(
        _.mergeMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequestTarget.ReadOnly =
    zio.aws.codecommit.model.PullRequestTarget.wrap(buildAwsValue())
}
object PullRequestTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequestTarget =
      zio.aws.codecommit.model.PullRequestTarget(
        repositoryName.map(value => value),
        sourceReference.map(value => value),
        destinationReference.map(value => value),
        destinationCommit.map(value => value),
        sourceCommit.map(value => value),
        mergeBase.map(value => value),
        mergeMetadata.map(value => value.asEditable)
      )
    def repositoryName: Optional[RepositoryName]
    def sourceReference: Optional[ReferenceName]
    def destinationReference: Optional[ReferenceName]
    def destinationCommit: Optional[CommitId]
    def sourceCommit: Optional[CommitId]
    def mergeBase: Optional[CommitId]
    def mergeMetadata: Optional[zio.aws.codecommit.model.MergeMetadata.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getSourceReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("sourceReference", sourceReference)
    def getDestinationReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("destinationReference", destinationReference)
    def getDestinationCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("destinationCommit", destinationCommit)
    def getSourceCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("sourceCommit", sourceCommit)
    def getMergeBase: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBase", mergeBase)
    def getMergeMetadata
        : ZIO[Any, AwsError, zio.aws.codecommit.model.MergeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("mergeMetadata", mergeMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ) extends zio.aws.codecommit.model.PullRequestTarget.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val sourceReference: Optional[ReferenceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceReference())
        .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
    override val destinationReference: Optional[ReferenceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationReference())
        .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
    override val destinationCommit: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCommit())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val sourceCommit: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCommit())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeBase: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.mergeBase())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeMetadata
        : Optional[zio.aws.codecommit.model.MergeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeMetadata())
        .map(value => zio.aws.codecommit.model.MergeMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ): zio.aws.codecommit.model.PullRequestTarget.ReadOnly = new Wrapper(impl)
}
