package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileModes(
    source: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      Optional.Absent,
    destination: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      Optional.Absent,
    base: Optional[zio.aws.codecommit.model.FileModeTypeEnum] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.FileModes = {
    import FileModes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.FileModes
      .builder()
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(destination.map(value => value.unwrap))(_.destination)
      .optionallyWith(base.map(value => value.unwrap))(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.FileModes.ReadOnly =
    zio.aws.codecommit.model.FileModes.wrap(buildAwsValue())
}
object FileModes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.FileModes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.FileModes =
      zio.aws.codecommit.model.FileModes(
        source.map(value => value),
        destination.map(value => value),
        base.map(value => value)
      )
    def source: Optional[zio.aws.codecommit.model.FileModeTypeEnum]
    def destination: Optional[zio.aws.codecommit.model.FileModeTypeEnum]
    def base: Optional[zio.aws.codecommit.model.FileModeTypeEnum]
    def getSource
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("source", source)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[Any, AwsError, zio.aws.codecommit.model.FileModeTypeEnum] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.FileModes
  ) extends zio.aws.codecommit.model.FileModes.ReadOnly {
    override val source: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
    override val destination
        : Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
    override val base: Optional[zio.aws.codecommit.model.FileModeTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.base())
        .map(value => zio.aws.codecommit.model.FileModeTypeEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.FileModes
  ): zio.aws.codecommit.model.FileModes.ReadOnly = new Wrapper(impl)
}
