package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ReactionValue, CommentId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutCommentReactionRequest(
    commentId: CommentId,
    reactionValue: ReactionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest = {
    import PutCommentReactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest
      .builder()
      .commentId(CommentId.unwrap(commentId): java.lang.String)
      .reactionValue(ReactionValue.unwrap(reactionValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PutCommentReactionRequest.ReadOnly =
    zio.aws.codecommit.model.PutCommentReactionRequest.wrap(buildAwsValue())
}
object PutCommentReactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PutCommentReactionRequest =
      zio.aws.codecommit.model
        .PutCommentReactionRequest(commentId, reactionValue)
    def commentId: CommentId
    def reactionValue: ReactionValue
    def getCommentId: ZIO[Any, Nothing, CommentId] = ZIO.succeed(commentId)
    def getReactionValue: ZIO[Any, Nothing, ReactionValue] =
      ZIO.succeed(reactionValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest
  ) extends zio.aws.codecommit.model.PutCommentReactionRequest.ReadOnly {
    override val commentId: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.commentId())
    override val reactionValue: ReactionValue =
      zio.aws.codecommit.model.primitives.ReactionValue(impl.reactionValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest
  ): zio.aws.codecommit.model.PutCommentReactionRequest.ReadOnly = new Wrapper(
    impl
  )
}
