package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ApprovalRuleId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePullRequestApprovalRuleResponse(
    approvalRuleId: ApprovalRuleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse = {
    import DeletePullRequestApprovalRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse
      .builder()
      .approvalRuleId(ApprovalRuleId.unwrap(approvalRuleId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly =
    zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse
      .wrap(buildAwsValue())
}
object DeletePullRequestApprovalRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse =
      zio.aws.codecommit.model
        .DeletePullRequestApprovalRuleResponse(approvalRuleId)
    def approvalRuleId: ApprovalRuleId
    def getApprovalRuleId: ZIO[Any, Nothing, ApprovalRuleId] =
      ZIO.succeed(approvalRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse
  ) extends zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly {
    override val approvalRuleId: ApprovalRuleId =
      zio.aws.codecommit.model.primitives.ApprovalRuleId(impl.approvalRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse
  ): zio.aws.codecommit.model.DeletePullRequestApprovalRuleResponse.ReadOnly =
    new Wrapper(impl)
}
