package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  KeepEmptyFolders,
  Message,
  RepositoryName,
  PullRequestId,
  Email,
  ObjectId,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MergePullRequestBySquashRequest(
    pullRequestId: PullRequestId,
    repositoryName: RepositoryName,
    sourceCommitId: Optional[ObjectId] = Optional.Absent,
    conflictDetailLevel: Optional[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = Optional.Absent,
    conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = Optional.Absent,
    commitMessage: Optional[Message] = Optional.Absent,
    authorName: Optional[Name] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    keepEmptyFolders: Optional[KeepEmptyFolders] = Optional.Absent,
    conflictResolution: Optional[zio.aws.codecommit.model.ConflictResolution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest = {
    import MergePullRequestBySquashRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        sourceCommitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.sourceCommitId)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly =
    zio.aws.codecommit.model.MergePullRequestBySquashRequest
      .wrap(buildAwsValue())
}
object MergePullRequestBySquashRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergePullRequestBySquashRequest =
      zio.aws.codecommit.model.MergePullRequestBySquashRequest(
        pullRequestId,
        repositoryName,
        sourceCommitId.map(value => value),
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value),
        commitMessage.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        keepEmptyFolders.map(value => value),
        conflictResolution.map(value => value.asEditable)
      )
    def pullRequestId: PullRequestId
    def repositoryName: RepositoryName
    def sourceCommitId: Optional[ObjectId]
    def conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Optional[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def commitMessage: Optional[Message]
    def authorName: Optional[Name]
    def email: Optional[Email]
    def keepEmptyFolders: Optional[KeepEmptyFolders]
    def conflictResolution
        : Optional[zio.aws.codecommit.model.ConflictResolution.ReadOnly]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("sourceCommitId", sourceCommitId)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ) extends zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCommitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val conflictDetailLevel
        : Optional[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictDetailLevel())
        .map(value =>
          zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
        )
    override val conflictResolutionStrategy: Optional[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictResolutionStrategy())
      .map(value =>
        zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum.wrap(value)
      )
    override val commitMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val authorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val keepEmptyFolders: Optional[KeepEmptyFolders] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keepEmptyFolders())
        .map(value =>
          zio.aws.codecommit.model.primitives.KeepEmptyFolders(value)
        )
    override val conflictResolution
        : Optional[zio.aws.codecommit.model.ConflictResolution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictResolution())
        .map(value => zio.aws.codecommit.model.ConflictResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest
  ): zio.aws.codecommit.model.MergePullRequestBySquashRequest.ReadOnly =
    new Wrapper(impl)
}
