package zio.aws.codecommit.model
import scala.jdk.CollectionConverters._
sealed trait ObjectTypeEnum {
  def unwrap: software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum
}
object ObjectTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum
  ): zio.aws.codecommit.model.ObjectTypeEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.FILE =>
      val r = FILE
      r
    case software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.DIRECTORY =>
      val r = DIRECTORY
      r
    case software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.GIT_LINK =>
      val r = GIT_LINK
      r
    case software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.SYMBOLIC_LINK =>
      val r = SYMBOLIC_LINK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE extends zio.aws.codecommit.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.FILE
  }
  case object DIRECTORY extends zio.aws.codecommit.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.DIRECTORY
  }
  case object GIT_LINK extends zio.aws.codecommit.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.GIT_LINK
  }
  case object SYMBOLIC_LINK extends zio.aws.codecommit.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum =
      software.amazon.awssdk.services.codecommit.model.ObjectTypeEnum.SYMBOLIC_LINK
  }
}
