package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  BranchName,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBranchRequest(
    repositoryName: RepositoryName,
    branchName: BranchName,
    commitId: CommitId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateBranchRequest = {
    import CreateBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateBranchRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .commitId(CommitId.unwrap(commitId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateBranchRequest.ReadOnly =
    zio.aws.codecommit.model.CreateBranchRequest.wrap(buildAwsValue())
}
object CreateBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateBranchRequest =
      zio.aws.codecommit.model
        .CreateBranchRequest(repositoryName, branchName, commitId)
    def repositoryName: RepositoryName
    def branchName: BranchName
    def commitId: CommitId
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getCommitId: ZIO[Any, Nothing, CommitId] = ZIO.succeed(commitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateBranchRequest
  ) extends zio.aws.codecommit.model.CreateBranchRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
    override val commitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.commitId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateBranchRequest
  ): zio.aws.codecommit.model.CreateBranchRequest.ReadOnly = new Wrapper(impl)
}
