package zio.aws.codecommit.model
import scala.jdk.CollectionConverters._
sealed trait RelativeFileVersionEnum {
  def unwrap
      : software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum
}
object RelativeFileVersionEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum
  ): zio.aws.codecommit.model.RelativeFileVersionEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.BEFORE =>
      val r = BEFORE
      r
    case software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.AFTER =>
      val r = AFTER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.RelativeFileVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum =
      software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object BEFORE extends zio.aws.codecommit.model.RelativeFileVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum =
      software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.BEFORE
  }
  case object AFTER extends zio.aws.codecommit.model.RelativeFileVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum =
      software.amazon.awssdk.services.codecommit.model.RelativeFileVersionEnum.AFTER
  }
}
