package zio.aws.codecommit.model
import scala.jdk.CollectionConverters._
sealed trait PullRequestStatusEnum {
  def unwrap
      : software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum
}
object PullRequestStatusEnum {
  def wrap(
      value: software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum
  ): zio.aws.codecommit.model.PullRequestStatusEnum = value match {
    case software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecommit.model.PullRequestStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum =
      software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.codecommit.model.PullRequestStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum =
      software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.OPEN
  }
  case object CLOSED extends zio.aws.codecommit.model.PullRequestStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum =
      software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum.CLOSED
  }
}
