package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRepositoryRequest(repositoryName: RepositoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest = {
    import DeleteRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.DeleteRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.DeleteRepositoryRequest.wrap(buildAwsValue())
}
object DeleteRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteRepositoryRequest =
      zio.aws.codecommit.model.DeleteRepositoryRequest(repositoryName)
    def repositoryName: RepositoryName
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest
  ) extends zio.aws.codecommit.model.DeleteRepositoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest
  ): zio.aws.codecommit.model.DeleteRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
