package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, PullRequestId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPullRequestsResponse(
    pullRequestIds: Iterable[PullRequestId],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse = {
    import ListPullRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse
      .builder()
      .pullRequestIds(pullRequestIds.map { item =>
        PullRequestId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly =
    zio.aws.codecommit.model.ListPullRequestsResponse.wrap(buildAwsValue())
}
object ListPullRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListPullRequestsResponse =
      zio.aws.codecommit.model
        .ListPullRequestsResponse(pullRequestIds, nextToken.map(value => value))
    def pullRequestIds: List[PullRequestId]
    def nextToken: Optional[NextToken]
    def getPullRequestIds: ZIO[Any, Nothing, List[PullRequestId]] =
      ZIO.succeed(pullRequestIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse
  ) extends zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly {
    override val pullRequestIds: List[PullRequestId] = impl
      .pullRequestIds()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.primitives.PullRequestId(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse
  ): zio.aws.codecommit.model.ListPullRequestsResponse.ReadOnly = new Wrapper(
    impl
  )
}
