package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.CommentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCommentContentRequest(commentId: CommentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest = {
    import DeleteCommentContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest
      .builder()
      .commentId(CommentId.unwrap(commentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.DeleteCommentContentRequest.ReadOnly =
    zio.aws.codecommit.model.DeleteCommentContentRequest.wrap(buildAwsValue())
}
object DeleteCommentContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.DeleteCommentContentRequest =
      zio.aws.codecommit.model.DeleteCommentContentRequest(commentId)
    def commentId: CommentId
    def getCommentId: ZIO[Any, Nothing, CommentId] = ZIO.succeed(commentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest
  ) extends zio.aws.codecommit.model.DeleteCommentContentRequest.ReadOnly {
    override val commentId: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.commentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest
  ): zio.aws.codecommit.model.DeleteCommentContentRequest.ReadOnly =
    new Wrapper(impl)
}
