package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubModule(
    commitId: Optional[ObjectId] = Optional.Absent,
    absolutePath: Optional[Path] = Optional.Absent,
    relativePath: Optional[Path] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.SubModule = {
    import SubModule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.SubModule
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        absolutePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.absolutePath)
      .optionallyWith(
        relativePath.map(value => Path.unwrap(value): java.lang.String)
      )(_.relativePath)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.SubModule.ReadOnly =
    zio.aws.codecommit.model.SubModule.wrap(buildAwsValue())
}
object SubModule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.SubModule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.SubModule =
      zio.aws.codecommit.model.SubModule(
        commitId.map(value => value),
        absolutePath.map(value => value),
        relativePath.map(value => value)
      )
    def commitId: Optional[ObjectId]
    def absolutePath: Optional[Path]
    def relativePath: Optional[Path]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getAbsolutePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("absolutePath", absolutePath)
    def getRelativePath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("relativePath", relativePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.SubModule
  ) extends zio.aws.codecommit.model.SubModule.ReadOnly {
    override val commitId: Optional[ObjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val absolutePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.absolutePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val relativePath: Optional[Path] = zio.aws.core.internal
      .optionalFromNullable(impl.relativePath())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.SubModule
  ): zio.aws.codecommit.model.SubModule.ReadOnly = new Wrapper(impl)
}
