package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PullRequestSourceReferenceUpdatedEventMetadata(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    beforeCommitId: Optional[CommitId] = Optional.Absent,
    afterCommitId: Optional[CommitId] = Optional.Absent,
    mergeBase: Optional[CommitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata = {
    import PullRequestSourceReferenceUpdatedEventMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        mergeBase.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBase)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly =
    zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
      .wrap(buildAwsValue())
}
object PullRequestSourceReferenceUpdatedEventMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata =
      zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata(
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        mergeBase.map(value => value)
      )
    def repositoryName: Optional[RepositoryName]
    def beforeCommitId: Optional[CommitId]
    def afterCommitId: Optional[CommitId]
    def mergeBase: Optional[CommitId]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getMergeBase: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBase", mergeBase)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ) extends zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeBase: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.mergeBase())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata
  ): zio.aws.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.ReadOnly =
    new Wrapper(impl)
}
