package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ApprovalRuleName,
  Overridden,
  Approved
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Evaluation(
    approved: Optional[Approved] = Optional.Absent,
    overridden: Optional[Overridden] = Optional.Absent,
    approvalRulesSatisfied: Optional[Iterable[ApprovalRuleName]] =
      Optional.Absent,
    approvalRulesNotSatisfied: Optional[Iterable[ApprovalRuleName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.Evaluation = {
    import Evaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.Evaluation
      .builder()
      .optionallyWith(
        approved.map(value => Approved.unwrap(value): java.lang.Boolean)
      )(_.approved)
      .optionallyWith(
        overridden.map(value => Overridden.unwrap(value): java.lang.Boolean)
      )(_.overridden)
      .optionallyWith(
        approvalRulesSatisfied.map(value =>
          value.map { item =>
            ApprovalRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRulesSatisfied)
      .optionallyWith(
        approvalRulesNotSatisfied.map(value =>
          value.map { item =>
            ApprovalRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRulesNotSatisfied)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.Evaluation.ReadOnly =
    zio.aws.codecommit.model.Evaluation.wrap(buildAwsValue())
}
object Evaluation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.Evaluation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.Evaluation =
      zio.aws.codecommit.model.Evaluation(
        approved.map(value => value),
        overridden.map(value => value),
        approvalRulesSatisfied.map(value => value),
        approvalRulesNotSatisfied.map(value => value)
      )
    def approved: Optional[Approved]
    def overridden: Optional[Overridden]
    def approvalRulesSatisfied: Optional[List[ApprovalRuleName]]
    def approvalRulesNotSatisfied: Optional[List[ApprovalRuleName]]
    def getApproved: ZIO[Any, AwsError, Approved] =
      AwsError.unwrapOptionField("approved", approved)
    def getOverridden: ZIO[Any, AwsError, Overridden] =
      AwsError.unwrapOptionField("overridden", overridden)
    def getApprovalRulesSatisfied: ZIO[Any, AwsError, List[ApprovalRuleName]] =
      AwsError.unwrapOptionField(
        "approvalRulesSatisfied",
        approvalRulesSatisfied
      )
    def getApprovalRulesNotSatisfied
        : ZIO[Any, AwsError, List[ApprovalRuleName]] = AwsError
      .unwrapOptionField("approvalRulesNotSatisfied", approvalRulesNotSatisfied)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.Evaluation
  ) extends zio.aws.codecommit.model.Evaluation.ReadOnly {
    override val approved: Optional[Approved] = zio.aws.core.internal
      .optionalFromNullable(impl.approved())
      .map(value => zio.aws.codecommit.model.primitives.Approved(value))
    override val overridden: Optional[Overridden] = zio.aws.core.internal
      .optionalFromNullable(impl.overridden())
      .map(value => zio.aws.codecommit.model.primitives.Overridden(value))
    override val approvalRulesSatisfied: Optional[List[ApprovalRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRulesSatisfied())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.ApprovalRuleName(item)
          }.toList
        )
    override val approvalRulesNotSatisfied: Optional[List[ApprovalRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRulesNotSatisfied())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.ApprovalRuleName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.Evaluation
  ): zio.aws.codecommit.model.Evaluation.ReadOnly = new Wrapper(impl)
}
