package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCommentsForComparedCommitResponse(
    commentsForComparedCommitData: Optional[
      Iterable[zio.aws.codecommit.model.CommentsForComparedCommit]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse = {
    import GetCommentsForComparedCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse
      .builder()
      .optionallyWith(
        commentsForComparedCommitData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commentsForComparedCommitData)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly =
    zio.aws.codecommit.model.GetCommentsForComparedCommitResponse
      .wrap(buildAwsValue())
}
object GetCommentsForComparedCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetCommentsForComparedCommitResponse =
      zio.aws.codecommit.model.GetCommentsForComparedCommitResponse(
        commentsForComparedCommitData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def commentsForComparedCommitData: Optional[
      List[zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getCommentsForComparedCommitData: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "commentsForComparedCommitData",
      commentsForComparedCommitData
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse
  ) extends zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly {
    override val commentsForComparedCommitData: Optional[
      List[zio.aws.codecommit.model.CommentsForComparedCommit.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commentsForComparedCommitData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.CommentsForComparedCommit.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse
  ): zio.aws.codecommit.model.GetCommentsForComparedCommitResponse.ReadOnly =
    new Wrapper(impl)
}
