package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Arn, Overridden}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPullRequestOverrideStateResponse(
    overridden: Optional[Overridden] = Optional.Absent,
    overrider: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse = {
    import GetPullRequestOverrideStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
      .builder()
      .optionallyWith(
        overridden.map(value => Overridden.unwrap(value): java.lang.Boolean)
      )(_.overridden)
      .optionallyWith(
        overrider.map(value => Arn.unwrap(value): java.lang.String)
      )(_.overrider)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly =
    zio.aws.codecommit.model.GetPullRequestOverrideStateResponse
      .wrap(buildAwsValue())
}
object GetPullRequestOverrideStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.GetPullRequestOverrideStateResponse =
      zio.aws.codecommit.model.GetPullRequestOverrideStateResponse(
        overridden.map(value => value),
        overrider.map(value => value)
      )
    def overridden: Optional[Overridden]
    def overrider: Optional[Arn]
    def getOverridden: ZIO[Any, AwsError, Overridden] =
      AwsError.unwrapOptionField("overridden", overridden)
    def getOverrider: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("overrider", overrider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ) extends zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly {
    override val overridden: Optional[Overridden] = zio.aws.core.internal
      .optionalFromNullable(impl.overridden())
      .map(value => zio.aws.codecommit.model.primitives.Overridden(value))
    override val overrider: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.overrider())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse
  ): zio.aws.codecommit.model.GetPullRequestOverrideStateResponse.ReadOnly =
    new Wrapper(impl)
}
