package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBranchesRequest(
    repositoryName: RepositoryName,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListBranchesRequest = {
    import ListBranchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListBranchesRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ListBranchesRequest.ReadOnly =
    zio.aws.codecommit.model.ListBranchesRequest.wrap(buildAwsValue())
}
object ListBranchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListBranchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ListBranchesRequest =
      zio.aws.codecommit.model
        .ListBranchesRequest(repositoryName, nextToken.map(value => value))
    def repositoryName: RepositoryName
    def nextToken: Optional[NextToken]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListBranchesRequest
  ) extends zio.aws.codecommit.model.ListBranchesRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListBranchesRequest
  ): zio.aws.codecommit.model.ListBranchesRequest.ReadOnly = new Wrapper(impl)
}
