package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDifferencesResponse(
    differences: Option[Iterable[zio.aws.codecommit.model.Difference]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse = {
    import GetDifferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse
      .builder()
      .optionallyWith(
        differences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.differences)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly =
    zio.aws.codecommit.model.GetDifferencesResponse.wrap(buildAwsValue())
}
object GetDifferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetDifferencesResponse =
      zio.aws.codecommit.model.GetDifferencesResponse(
        differences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def differences: Option[List[zio.aws.codecommit.model.Difference.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDifferences: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.Difference.ReadOnly
    ]] = AwsError.unwrapOptionField("differences", differences)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse
  ) extends zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly {
    override val differences
        : Option[List[zio.aws.codecommit.model.Difference.ReadOnly]] = scala
      .Option(impl.differences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Difference.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse
  ): zio.aws.codecommit.model.GetDifferencesResponse.ReadOnly = new Wrapper(
    impl
  )
}
