package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergeBranchesByThreeWayResponse(
    commitId: Option[ObjectId] = None,
    treeId: Option[ObjectId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse = {
    import MergeBranchesByThreeWayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly =
    zio.aws.codecommit.model.MergeBranchesByThreeWayResponse
      .wrap(buildAwsValue())
}
object MergeBranchesByThreeWayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeBranchesByThreeWayResponse =
      zio.aws.codecommit.model.MergeBranchesByThreeWayResponse(
        commitId.map(value => value),
        treeId.map(value => value)
      )
    def commitId: Option[ObjectId]
    def treeId: Option[ObjectId]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ) extends zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly {
    override val commitId: Option[ObjectId] = scala
      .Option(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Option[ObjectId] = scala
      .Option(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse
  ): zio.aws.codecommit.model.MergeBranchesByThreeWayResponse.ReadOnly =
    new Wrapper(impl)
}
