package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCommentResponse(
    comment: Option[zio.aws.codecommit.model.Comment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse = {
    import UpdateCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly =
    zio.aws.codecommit.model.UpdateCommentResponse.wrap(buildAwsValue())
}
object UpdateCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UpdateCommentResponse =
      zio.aws.codecommit.model
        .UpdateCommentResponse(comment.map(value => value.asEditable))
    def comment: Option[zio.aws.codecommit.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ) extends zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly {
    override val comment: Option[zio.aws.codecommit.model.Comment.ReadOnly] =
      scala
        .Option(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse
  ): zio.aws.codecommit.model.UpdateCommentResponse.ReadOnly = new Wrapper(impl)
}
