package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  TagValue,
  TagKey,
  RepositoryDescription,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRepositoryRequest(
    repositoryName: RepositoryName,
    repositoryDescription: Option[RepositoryDescription] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest = {
    import CreateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        repositoryDescription.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.repositoryDescription)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly =
    zio.aws.codecommit.model.CreateRepositoryRequest.wrap(buildAwsValue())
}
object CreateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateRepositoryRequest =
      zio.aws.codecommit.model.CreateRepositoryRequest(
        repositoryName,
        repositoryDescription.map(value => value),
        tags.map(value => value)
      )
    def repositoryName: RepositoryName
    def repositoryDescription: Option[RepositoryDescription]
    def tags: Option[Map[TagKey, TagValue]]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("repositoryDescription", repositoryDescription)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ) extends zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryDescription: Option[RepositoryDescription] = scala
      .Option(impl.repositoryDescription())
      .map(value =>
        zio.aws.codecommit.model.primitives.RepositoryDescription(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codecommit.model.primitives.TagKey(
              key
            ) -> zio.aws.codecommit.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest
  ): zio.aws.codecommit.model.CreateRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
