package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  ReferenceName,
  RepositoryName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PullRequestTarget(
    repositoryName: Option[RepositoryName] = None,
    sourceReference: Option[ReferenceName] = None,
    destinationReference: Option[ReferenceName] = None,
    destinationCommit: Option[CommitId] = None,
    sourceCommit: Option[CommitId] = None,
    mergeBase: Option[CommitId] = None,
    mergeMetadata: Option[zio.aws.codecommit.model.MergeMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequestTarget = {
    import PullRequestTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequestTarget
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        sourceReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.sourceReference)
      .optionallyWith(
        destinationReference.map(value =>
          ReferenceName.unwrap(value): java.lang.String
        )
      )(_.destinationReference)
      .optionallyWith(
        destinationCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.destinationCommit)
      .optionallyWith(
        sourceCommit.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.sourceCommit)
      .optionallyWith(
        mergeBase.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.mergeBase)
      .optionallyWith(mergeMetadata.map(value => value.buildAwsValue()))(
        _.mergeMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequestTarget.ReadOnly =
    zio.aws.codecommit.model.PullRequestTarget.wrap(buildAwsValue())
}
object PullRequestTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequestTarget =
      zio.aws.codecommit.model.PullRequestTarget(
        repositoryName.map(value => value),
        sourceReference.map(value => value),
        destinationReference.map(value => value),
        destinationCommit.map(value => value),
        sourceCommit.map(value => value),
        mergeBase.map(value => value),
        mergeMetadata.map(value => value.asEditable)
      )
    def repositoryName: Option[RepositoryName]
    def sourceReference: Option[ReferenceName]
    def destinationReference: Option[ReferenceName]
    def destinationCommit: Option[CommitId]
    def sourceCommit: Option[CommitId]
    def mergeBase: Option[CommitId]
    def mergeMetadata: Option[zio.aws.codecommit.model.MergeMetadata.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getSourceReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("sourceReference", sourceReference)
    def getDestinationReference: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("destinationReference", destinationReference)
    def getDestinationCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("destinationCommit", destinationCommit)
    def getSourceCommit: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("sourceCommit", sourceCommit)
    def getMergeBase: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("mergeBase", mergeBase)
    def getMergeMetadata
        : ZIO[Any, AwsError, zio.aws.codecommit.model.MergeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("mergeMetadata", mergeMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ) extends zio.aws.codecommit.model.PullRequestTarget.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val sourceReference: Option[ReferenceName] = scala
      .Option(impl.sourceReference())
      .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
    override val destinationReference: Option[ReferenceName] = scala
      .Option(impl.destinationReference())
      .map(value => zio.aws.codecommit.model.primitives.ReferenceName(value))
    override val destinationCommit: Option[CommitId] = scala
      .Option(impl.destinationCommit())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val sourceCommit: Option[CommitId] = scala
      .Option(impl.sourceCommit())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeBase: Option[CommitId] = scala
      .Option(impl.mergeBase())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val mergeMetadata
        : Option[zio.aws.codecommit.model.MergeMetadata.ReadOnly] = scala
      .Option(impl.mergeMetadata())
      .map(value => zio.aws.codecommit.model.MergeMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequestTarget
  ): zio.aws.codecommit.model.PullRequestTarget.ReadOnly = new Wrapper(impl)
}
