package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.ObjectId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCommitResponse(
    commitId: Option[ObjectId] = None,
    treeId: Option[ObjectId] = None,
    filesAdded: Option[Iterable[zio.aws.codecommit.model.FileMetadata]] = None,
    filesUpdated: Option[Iterable[zio.aws.codecommit.model.FileMetadata]] =
      None,
    filesDeleted: Option[Iterable[zio.aws.codecommit.model.FileMetadata]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateCommitResponse = {
    import CreateCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
      .builder()
      .optionallyWith(
        commitId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        treeId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.treeId)
      .optionallyWith(
        filesAdded.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesAdded)
      .optionallyWith(
        filesUpdated.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesUpdated)
      .optionallyWith(
        filesDeleted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filesDeleted)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateCommitResponse.ReadOnly =
    zio.aws.codecommit.model.CreateCommitResponse.wrap(buildAwsValue())
}
object CreateCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateCommitResponse =
      zio.aws.codecommit.model.CreateCommitResponse(
        commitId.map(value => value),
        treeId.map(value => value),
        filesAdded.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filesUpdated.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filesDeleted.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def commitId: Option[ObjectId]
    def treeId: Option[ObjectId]
    def filesAdded: Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def filesUpdated
        : Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def filesDeleted
        : Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]]
    def getCommitId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getTreeId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("treeId", treeId)
    def getFilesAdded: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesAdded", filesAdded)
    def getFilesUpdated: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesUpdated", filesUpdated)
    def getFilesDeleted: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.FileMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("filesDeleted", filesDeleted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ) extends zio.aws.codecommit.model.CreateCommitResponse.ReadOnly {
    override val commitId: Option[ObjectId] = scala
      .Option(impl.commitId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val treeId: Option[ObjectId] = scala
      .Option(impl.treeId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val filesAdded
        : Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] = scala
      .Option(impl.filesAdded())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.FileMetadata.wrap(item)
        }.toList
      )
    override val filesUpdated
        : Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] = scala
      .Option(impl.filesUpdated())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.FileMetadata.wrap(item)
        }.toList
      )
    override val filesDeleted
        : Option[List[zio.aws.codecommit.model.FileMetadata.ReadOnly]] = scala
      .Option(impl.filesDeleted())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.FileMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitResponse
  ): zio.aws.codecommit.model.CreateCommitResponse.ReadOnly = new Wrapper(impl)
}
