package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, CommitId, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PostCommentForComparedCommitResponse(
    repositoryName: Option[RepositoryName] = None,
    beforeCommitId: Option[CommitId] = None,
    afterCommitId: Option[CommitId] = None,
    beforeBlobId: Option[ObjectId] = None,
    afterBlobId: Option[ObjectId] = None,
    location: Option[zio.aws.codecommit.model.Location] = None,
    comment: Option[zio.aws.codecommit.model.Comment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse = {
    import PostCommentForComparedCommitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        beforeCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.beforeCommitId)
      .optionallyWith(
        afterCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.afterCommitId)
      .optionallyWith(
        beforeBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.beforeBlobId)
      .optionallyWith(
        afterBlobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.afterBlobId)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly =
    zio.aws.codecommit.model.PostCommentForComparedCommitResponse
      .wrap(buildAwsValue())
}
object PostCommentForComparedCommitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.PostCommentForComparedCommitResponse =
      zio.aws.codecommit.model.PostCommentForComparedCommitResponse(
        repositoryName.map(value => value),
        beforeCommitId.map(value => value),
        afterCommitId.map(value => value),
        beforeBlobId.map(value => value),
        afterBlobId.map(value => value),
        location.map(value => value.asEditable),
        comment.map(value => value.asEditable)
      )
    def repositoryName: Option[RepositoryName]
    def beforeCommitId: Option[CommitId]
    def afterCommitId: Option[CommitId]
    def beforeBlobId: Option[ObjectId]
    def afterBlobId: Option[ObjectId]
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def comment: Option[zio.aws.codecommit.model.Comment.ReadOnly]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getBeforeCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("beforeCommitId", beforeCommitId)
    def getAfterCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("afterCommitId", afterCommitId)
    def getBeforeBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("beforeBlobId", beforeBlobId)
    def getAfterBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("afterBlobId", afterBlobId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getComment
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ) extends zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly {
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val beforeCommitId: Option[CommitId] = scala
      .Option(impl.beforeCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val afterCommitId: Option[CommitId] = scala
      .Option(impl.afterCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val beforeBlobId: Option[ObjectId] = scala
      .Option(impl.beforeBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val afterBlobId: Option[ObjectId] = scala
      .Option(impl.afterBlobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val comment: Option[zio.aws.codecommit.model.Comment.ReadOnly] =
      scala
        .Option(impl.comment())
        .map(value => zio.aws.codecommit.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse
  ): zio.aws.codecommit.model.PostCommentForComparedCommitResponse.ReadOnly =
    new Wrapper(impl)
}
