package zio.aws.codecommit.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchGetCommitsResponse(
    commits: Option[Iterable[zio.aws.codecommit.model.Commit]] = None,
    errors: Option[Iterable[zio.aws.codecommit.model.BatchGetCommitsError]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse = {
    import BatchGetCommitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse
      .builder()
      .optionallyWith(
        commits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commits)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly =
    zio.aws.codecommit.model.BatchGetCommitsResponse.wrap(buildAwsValue())
}
object BatchGetCommitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BatchGetCommitsResponse =
      zio.aws.codecommit.model.BatchGetCommitsResponse(
        commits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def commits: Option[List[zio.aws.codecommit.model.Commit.ReadOnly]]
    def errors
        : Option[List[zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly]]
    def getCommits
        : ZIO[Any, AwsError, List[zio.aws.codecommit.model.Commit.ReadOnly]] =
      AwsError.unwrapOptionField("commits", commits)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse
  ) extends zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly {
    override val commits
        : Option[List[zio.aws.codecommit.model.Commit.ReadOnly]] = scala
      .Option(impl.commits())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.Commit.wrap(item)
        }.toList
      )
    override val errors
        : Option[List[zio.aws.codecommit.model.BatchGetCommitsError.ReadOnly]] =
      scala
        .Option(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.BatchGetCommitsError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse
  ): zio.aws.codecommit.model.BatchGetCommitsResponse.ReadOnly = new Wrapper(
    impl
  )
}
