package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  ClientRequestToken,
  RepositoryName,
  PullRequestId,
  Content
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PostCommentForPullRequestRequest(
    pullRequestId: PullRequestId,
    repositoryName: RepositoryName,
    beforeCommitId: CommitId,
    afterCommitId: CommitId,
    location: Option[zio.aws.codecommit.model.Location] = None,
    content: Content,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest = {
    import PostCommentForPullRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest
      .builder()
      .pullRequestId(PullRequestId.unwrap(pullRequestId): java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .beforeCommitId(CommitId.unwrap(beforeCommitId): java.lang.String)
      .afterCommitId(CommitId.unwrap(afterCommitId): java.lang.String)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .content(Content.unwrap(content): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.PostCommentForPullRequestRequest.ReadOnly =
    zio.aws.codecommit.model.PostCommentForPullRequestRequest
      .wrap(buildAwsValue())
}
object PostCommentForPullRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PostCommentForPullRequestRequest =
      zio.aws.codecommit.model.PostCommentForPullRequestRequest(
        pullRequestId,
        repositoryName,
        beforeCommitId,
        afterCommitId,
        location.map(value => value.asEditable),
        content,
        clientRequestToken.map(value => value)
      )
    def pullRequestId: PullRequestId
    def repositoryName: RepositoryName
    def beforeCommitId: CommitId
    def afterCommitId: CommitId
    def location: Option[zio.aws.codecommit.model.Location.ReadOnly]
    def content: Content
    def clientRequestToken: Option[ClientRequestToken]
    def getPullRequestId: ZIO[Any, Nothing, PullRequestId] =
      ZIO.succeed(pullRequestId)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBeforeCommitId: ZIO[Any, Nothing, CommitId] =
      ZIO.succeed(beforeCommitId)
    def getAfterCommitId: ZIO[Any, Nothing, CommitId] =
      ZIO.succeed(afterCommitId)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.codecommit.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest
  ) extends zio.aws.codecommit.model.PostCommentForPullRequestRequest.ReadOnly {
    override val pullRequestId: PullRequestId =
      zio.aws.codecommit.model.primitives.PullRequestId(impl.pullRequestId())
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val beforeCommitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.beforeCommitId())
    override val afterCommitId: CommitId =
      zio.aws.codecommit.model.primitives.CommitId(impl.afterCommitId())
    override val location: Option[zio.aws.codecommit.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.codecommit.model.Location.wrap(value))
    override val content: Content =
      zio.aws.codecommit.model.primitives.Content(impl.content())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codecommit.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest
  ): zio.aws.codecommit.model.PostCommentForPullRequestRequest.ReadOnly =
    new Wrapper(impl)
}
