package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  MaxResults,
  NextToken,
  ApprovalRuleTemplateName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRepositoriesForApprovalRuleTemplateRequest(
    approvalRuleTemplateName: ApprovalRuleTemplateName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest = {
    import ListRepositoriesForApprovalRuleTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
      .builder()
      .approvalRuleTemplateName(
        ApprovalRuleTemplateName.unwrap(
          approvalRuleTemplateName
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly =
    zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
      .wrap(buildAwsValue())
}
object ListRepositoriesForApprovalRuleTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest =
      zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest(
        approvalRuleTemplateName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def approvalRuleTemplateName: ApprovalRuleTemplateName
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getApprovalRuleTemplateName
        : ZIO[Any, Nothing, ApprovalRuleTemplateName] =
      ZIO.succeed(approvalRuleTemplateName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ) extends zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly {
    override val approvalRuleTemplateName: ApprovalRuleTemplateName =
      zio.aws.codecommit.model.primitives
        .ApprovalRuleTemplateName(impl.approvalRuleTemplateName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codecommit.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
  ): zio.aws.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
