package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Path, CommitName, RepositoryName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFileRequest(
    repositoryName: RepositoryName,
    commitSpecifier: Option[CommitName] = None,
    filePath: Path
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetFileRequest = {
    import GetFileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetFileRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .optionallyWith(
        commitSpecifier.map(value => CommitName.unwrap(value): java.lang.String)
      )(_.commitSpecifier)
      .filePath(Path.unwrap(filePath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetFileRequest.ReadOnly =
    zio.aws.codecommit.model.GetFileRequest.wrap(buildAwsValue())
}
object GetFileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetFileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetFileRequest =
      zio.aws.codecommit.model.GetFileRequest(
        repositoryName,
        commitSpecifier.map(value => value),
        filePath
      )
    def repositoryName: RepositoryName
    def commitSpecifier: Option[CommitName]
    def filePath: Path
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getCommitSpecifier: ZIO[Any, AwsError, CommitName] =
      AwsError.unwrapOptionField("commitSpecifier", commitSpecifier)
    def getFilePath: ZIO[Any, Nothing, Path] = ZIO.succeed(filePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetFileRequest
  ) extends zio.aws.codecommit.model.GetFileRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val commitSpecifier: Option[CommitName] = scala
      .Option(impl.commitSpecifier())
      .map(value => zio.aws.codecommit.model.primitives.CommitName(value))
    override val filePath: Path =
      zio.aws.codecommit.model.primitives.Path(impl.filePath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetFileRequest
  ): zio.aws.codecommit.model.GetFileRequest.ReadOnly = new Wrapper(impl)
}
