package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{TagValue, TagKey, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.TagResourceRequest.ReadOnly =
    zio.aws.codecommit.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.TagResourceRequest =
      zio.aws.codecommit.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ResourceArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.TagResourceRequest
  ) extends zio.aws.codecommit.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.codecommit.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codecommit.model.primitives
          .TagKey(key) -> zio.aws.codecommit.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.TagResourceRequest
  ): zio.aws.codecommit.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
