package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{HunkContent, LineNumber}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergeHunkDetail(
    startLine: Option[LineNumber] = None,
    endLine: Option[LineNumber] = None,
    hunkContent: Option[HunkContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeHunkDetail = {
    import MergeHunkDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeHunkDetail
      .builder()
      .optionallyWith(
        startLine.map(value => LineNumber.unwrap(value): Integer)
      )(_.startLine)
      .optionallyWith(endLine.map(value => LineNumber.unwrap(value): Integer))(
        _.endLine
      )
      .optionallyWith(
        hunkContent.map(value => HunkContent.unwrap(value): java.lang.String)
      )(_.hunkContent)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.MergeHunkDetail.ReadOnly =
    zio.aws.codecommit.model.MergeHunkDetail.wrap(buildAwsValue())
}
object MergeHunkDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeHunkDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeHunkDetail =
      zio.aws.codecommit.model.MergeHunkDetail(
        startLine.map(value => value),
        endLine.map(value => value),
        hunkContent.map(value => value)
      )
    def startLine: Option[LineNumber]
    def endLine: Option[LineNumber]
    def hunkContent: Option[HunkContent]
    def getStartLine: ZIO[Any, AwsError, LineNumber] =
      AwsError.unwrapOptionField("startLine", startLine)
    def getEndLine: ZIO[Any, AwsError, LineNumber] =
      AwsError.unwrapOptionField("endLine", endLine)
    def getHunkContent: ZIO[Any, AwsError, HunkContent] =
      AwsError.unwrapOptionField("hunkContent", hunkContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeHunkDetail
  ) extends zio.aws.codecommit.model.MergeHunkDetail.ReadOnly {
    override val startLine: Option[LineNumber] = scala
      .Option(impl.startLine())
      .map(value => zio.aws.codecommit.model.primitives.LineNumber(value))
    override val endLine: Option[LineNumber] = scala
      .Option(impl.endLine())
      .map(value => zio.aws.codecommit.model.primitives.LineNumber(value))
    override val hunkContent: Option[HunkContent] = scala
      .Option(impl.hunkContent())
      .map(value => zio.aws.codecommit.model.primitives.HunkContent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeHunkDetail
  ): zio.aws.codecommit.model.MergeHunkDetail.ReadOnly = new Wrapper(impl)
}
