package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.CapitalBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IsBinaryFile(
    source: Option[CapitalBoolean] = None,
    destination: Option[CapitalBoolean] = None,
    base: Option[CapitalBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.IsBinaryFile = {
    import IsBinaryFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.IsBinaryFile
      .builder()
      .optionallyWith(
        source.map(value => CapitalBoolean.unwrap(value): java.lang.Boolean)
      )(_.source)
      .optionallyWith(
        destination.map(value =>
          CapitalBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.destination)
      .optionallyWith(
        base.map(value => CapitalBoolean.unwrap(value): java.lang.Boolean)
      )(_.base)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.IsBinaryFile.ReadOnly =
    zio.aws.codecommit.model.IsBinaryFile.wrap(buildAwsValue())
}
object IsBinaryFile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.IsBinaryFile =
      zio.aws.codecommit.model.IsBinaryFile(
        source.map(value => value),
        destination.map(value => value),
        base.map(value => value)
      )
    def source: Option[CapitalBoolean]
    def destination: Option[CapitalBoolean]
    def base: Option[CapitalBoolean]
    def getSource: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("destination", destination)
    def getBase: ZIO[Any, AwsError, CapitalBoolean] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ) extends zio.aws.codecommit.model.IsBinaryFile.ReadOnly {
    override val source: Option[CapitalBoolean] = scala
      .Option(impl.source())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
    override val destination: Option[CapitalBoolean] = scala
      .Option(impl.destination())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
    override val base: Option[CapitalBoolean] = scala
      .Option(impl.base())
      .map(value => zio.aws.codecommit.model.primitives.CapitalBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.IsBinaryFile
  ): zio.aws.codecommit.model.IsBinaryFile.ReadOnly = new Wrapper(impl)
}
