package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitName,
  KeepEmptyFolders,
  Message,
  RepositoryName,
  Email,
  Name,
  BranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MergeBranchesBySquashRequest(
    repositoryName: RepositoryName,
    sourceCommitSpecifier: CommitName,
    destinationCommitSpecifier: CommitName,
    targetBranch: Option[BranchName] = None,
    conflictDetailLevel: Option[
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = None,
    conflictResolutionStrategy: Option[
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = None,
    authorName: Option[Name] = None,
    email: Option[Email] = None,
    commitMessage: Option[Message] = None,
    keepEmptyFolders: Option[KeepEmptyFolders] = None,
    conflictResolution: Option[zio.aws.codecommit.model.ConflictResolution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest = {
    import MergeBranchesBySquashRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .sourceCommitSpecifier(
        CommitName.unwrap(sourceCommitSpecifier): java.lang.String
      )
      .destinationCommitSpecifier(
        CommitName.unwrap(destinationCommitSpecifier): java.lang.String
      )
      .optionallyWith(
        targetBranch.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.targetBranch)
      .optionallyWith(conflictDetailLevel.map(value => value.unwrap))(
        _.conflictDetailLevel
      )
      .optionallyWith(conflictResolutionStrategy.map(value => value.unwrap))(
        _.conflictResolutionStrategy
      )
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(conflictResolution.map(value => value.buildAwsValue()))(
        _.conflictResolution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.MergeBranchesBySquashRequest.ReadOnly =
    zio.aws.codecommit.model.MergeBranchesBySquashRequest.wrap(buildAwsValue())
}
object MergeBranchesBySquashRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.MergeBranchesBySquashRequest =
      zio.aws.codecommit.model.MergeBranchesBySquashRequest(
        repositoryName,
        sourceCommitSpecifier,
        destinationCommitSpecifier,
        targetBranch.map(value => value),
        conflictDetailLevel.map(value => value),
        conflictResolutionStrategy.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        commitMessage.map(value => value),
        keepEmptyFolders.map(value => value),
        conflictResolution.map(value => value.asEditable)
      )
    def repositoryName: RepositoryName
    def sourceCommitSpecifier: CommitName
    def destinationCommitSpecifier: CommitName
    def targetBranch: Option[BranchName]
    def conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum]
    def conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum]
    def authorName: Option[Name]
    def email: Option[Email]
    def commitMessage: Option[Message]
    def keepEmptyFolders: Option[KeepEmptyFolders]
    def conflictResolution
        : Option[zio.aws.codecommit.model.ConflictResolution.ReadOnly]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getSourceCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(sourceCommitSpecifier)
    def getDestinationCommitSpecifier: ZIO[Any, Nothing, CommitName] =
      ZIO.succeed(destinationCommitSpecifier)
    def getTargetBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("targetBranch", targetBranch)
    def getConflictDetailLevel: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictDetailLevelTypeEnum
    ] = AwsError.unwrapOptionField("conflictDetailLevel", conflictDetailLevel)
    def getConflictResolutionStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
    ] = AwsError.unwrapOptionField(
      "conflictResolutionStrategy",
      conflictResolutionStrategy
    )
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getConflictResolution: ZIO[
      Any,
      AwsError,
      zio.aws.codecommit.model.ConflictResolution.ReadOnly
    ] = AwsError.unwrapOptionField("conflictResolution", conflictResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest
  ) extends zio.aws.codecommit.model.MergeBranchesBySquashRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val sourceCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.sourceCommitSpecifier())
    override val destinationCommitSpecifier: CommitName =
      zio.aws.codecommit.model.primitives
        .CommitName(impl.destinationCommitSpecifier())
    override val targetBranch: Option[BranchName] = scala
      .Option(impl.targetBranch())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
    override val conflictDetailLevel
        : Option[zio.aws.codecommit.model.ConflictDetailLevelTypeEnum] = scala
      .Option(impl.conflictDetailLevel())
      .map(value =>
        zio.aws.codecommit.model.ConflictDetailLevelTypeEnum.wrap(value)
      )
    override val conflictResolutionStrategy
        : Option[zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum] =
      scala
        .Option(impl.conflictResolutionStrategy())
        .map(value =>
          zio.aws.codecommit.model.ConflictResolutionStrategyTypeEnum
            .wrap(value)
        )
    override val authorName: Option[Name] = scala
      .Option(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val commitMessage: Option[Message] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val keepEmptyFolders: Option[KeepEmptyFolders] = scala
      .Option(impl.keepEmptyFolders())
      .map(value => zio.aws.codecommit.model.primitives.KeepEmptyFolders(value))
    override val conflictResolution
        : Option[zio.aws.codecommit.model.ConflictResolution.ReadOnly] = scala
      .Option(impl.conflictResolution())
      .map(value => zio.aws.codecommit.model.ConflictResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest
  ): zio.aws.codecommit.model.MergeBranchesBySquashRequest.ReadOnly =
    new Wrapper(impl)
}
