package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryTriggersConfigurationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRepositoryTriggersResponse(
    configurationId: Option[RepositoryTriggersConfigurationId] = None,
    triggers: Option[Iterable[zio.aws.codecommit.model.RepositoryTrigger]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse = {
    import GetRepositoryTriggersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse
      .builder()
      .optionallyWith(
        configurationId.map(value =>
          RepositoryTriggersConfigurationId.unwrap(value): java.lang.String
        )
      )(_.configurationId)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly =
    zio.aws.codecommit.model.GetRepositoryTriggersResponse.wrap(buildAwsValue())
}
object GetRepositoryTriggersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetRepositoryTriggersResponse =
      zio.aws.codecommit.model.GetRepositoryTriggersResponse(
        configurationId.map(value => value),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationId: Option[RepositoryTriggersConfigurationId]
    def triggers
        : Option[List[zio.aws.codecommit.model.RepositoryTrigger.ReadOnly]]
    def getConfigurationId
        : ZIO[Any, AwsError, RepositoryTriggersConfigurationId] =
      AwsError.unwrapOptionField("configurationId", configurationId)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.RepositoryTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse
  ) extends zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly {
    override val configurationId: Option[RepositoryTriggersConfigurationId] =
      scala
        .Option(impl.configurationId())
        .map(value =>
          zio.aws.codecommit.model.primitives
            .RepositoryTriggersConfigurationId(value)
        )
    override val triggers
        : Option[List[zio.aws.codecommit.model.RepositoryTrigger.ReadOnly]] =
      scala
        .Option(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.RepositoryTrigger.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse
  ): zio.aws.codecommit.model.GetRepositoryTriggersResponse.ReadOnly =
    new Wrapper(impl)
}
