package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.RepositoryTriggerName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestRepositoryTriggersResponse(
    successfulExecutions: Option[Iterable[RepositoryTriggerName]] = None,
    failedExecutions: Option[
      Iterable[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse = {
    import TestRepositoryTriggersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
      .builder()
      .optionallyWith(
        successfulExecutions.map(value =>
          value.map { item =>
            RepositoryTriggerName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.successfulExecutions)
      .optionallyWith(
        failedExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedExecutions)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly =
    zio.aws.codecommit.model.TestRepositoryTriggersResponse
      .wrap(buildAwsValue())
}
object TestRepositoryTriggersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.TestRepositoryTriggersResponse =
      zio.aws.codecommit.model.TestRepositoryTriggersResponse(
        successfulExecutions.map(value => value),
        failedExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulExecutions: Option[List[RepositoryTriggerName]]
    def failedExecutions: Option[
      List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly]
    ]
    def getSuccessfulExecutions
        : ZIO[Any, AwsError, List[RepositoryTriggerName]] =
      AwsError.unwrapOptionField("successfulExecutions", successfulExecutions)
    def getFailedExecutions: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failedExecutions", failedExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ) extends zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly {
    override val successfulExecutions: Option[List[RepositoryTriggerName]] =
      scala
        .Option(impl.successfulExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.primitives.RepositoryTriggerName(item)
          }.toList
        )
    override val failedExecutions: Option[
      List[zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.ReadOnly]
    ] = scala
      .Option(impl.failedExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.RepositoryTriggerExecutionFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse
  ): zio.aws.codecommit.model.TestRepositoryTriggersResponse.ReadOnly =
    new Wrapper(impl)
}
