package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ReactionUnicode,
  ReactionShortCode,
  ReactionEmoji
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReactionValueFormats(
    emoji: Option[ReactionEmoji] = None,
    shortCode: Option[ReactionShortCode] = None,
    unicode: Option[ReactionUnicode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ReactionValueFormats = {
    import ReactionValueFormats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
      .builder()
      .optionallyWith(
        emoji.map(value => ReactionEmoji.unwrap(value): java.lang.String)
      )(_.emoji)
      .optionallyWith(
        shortCode.map(value =>
          ReactionShortCode.unwrap(value): java.lang.String
        )
      )(_.shortCode)
      .optionallyWith(
        unicode.map(value => ReactionUnicode.unwrap(value): java.lang.String)
      )(_.unicode)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.ReactionValueFormats.ReadOnly =
    zio.aws.codecommit.model.ReactionValueFormats.wrap(buildAwsValue())
}
object ReactionValueFormats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.ReactionValueFormats =
      zio.aws.codecommit.model.ReactionValueFormats(
        emoji.map(value => value),
        shortCode.map(value => value),
        unicode.map(value => value)
      )
    def emoji: Option[ReactionEmoji]
    def shortCode: Option[ReactionShortCode]
    def unicode: Option[ReactionUnicode]
    def getEmoji: ZIO[Any, AwsError, ReactionEmoji] =
      AwsError.unwrapOptionField("emoji", emoji)
    def getShortCode: ZIO[Any, AwsError, ReactionShortCode] =
      AwsError.unwrapOptionField("shortCode", shortCode)
    def getUnicode: ZIO[Any, AwsError, ReactionUnicode] =
      AwsError.unwrapOptionField("unicode", unicode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ) extends zio.aws.codecommit.model.ReactionValueFormats.ReadOnly {
    override val emoji: Option[ReactionEmoji] = scala
      .Option(impl.emoji())
      .map(value => zio.aws.codecommit.model.primitives.ReactionEmoji(value))
    override val shortCode: Option[ReactionShortCode] = scala
      .Option(impl.shortCode())
      .map(value =>
        zio.aws.codecommit.model.primitives.ReactionShortCode(value)
      )
    override val unicode: Option[ReactionUnicode] = scala
      .Option(impl.unicode())
      .map(value => zio.aws.codecommit.model.primitives.ReactionUnicode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ReactionValueFormats
  ): zio.aws.codecommit.model.ReactionValueFormats.ReadOnly = new Wrapper(impl)
}
