package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  RepositoryDescription,
  AccountId,
  RepositoryName,
  Arn,
  CloneUrlSsh,
  LastModifiedDate,
  CloneUrlHttp,
  RepositoryId,
  BranchName,
  CreationDate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RepositoryMetadata(
    accountId: Option[AccountId] = None,
    repositoryId: Option[RepositoryId] = None,
    repositoryName: Option[RepositoryName] = None,
    repositoryDescription: Option[RepositoryDescription] = None,
    defaultBranch: Option[BranchName] = None,
    lastModifiedDate: Option[LastModifiedDate] = None,
    creationDate: Option[CreationDate] = None,
    cloneUrlHttp: Option[CloneUrlHttp] = None,
    cloneUrlSsh: Option[CloneUrlSsh] = None,
    arn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryMetadata = {
    import RepositoryMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        repositoryId.map(value => RepositoryId.unwrap(value): java.lang.String)
      )(_.repositoryId)
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        repositoryDescription.map(value =>
          RepositoryDescription.unwrap(value): java.lang.String
        )
      )(_.repositoryDescription)
      .optionallyWith(
        defaultBranch.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.defaultBranch)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        cloneUrlHttp.map(value => CloneUrlHttp.unwrap(value): java.lang.String)
      )(_.cloneUrlHttp)
      .optionallyWith(
        cloneUrlSsh.map(value => CloneUrlSsh.unwrap(value): java.lang.String)
      )(_.cloneUrlSsh)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.RepositoryMetadata.ReadOnly =
    zio.aws.codecommit.model.RepositoryMetadata.wrap(buildAwsValue())
}
object RepositoryMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryMetadata =
      zio.aws.codecommit.model.RepositoryMetadata(
        accountId.map(value => value),
        repositoryId.map(value => value),
        repositoryName.map(value => value),
        repositoryDescription.map(value => value),
        defaultBranch.map(value => value),
        lastModifiedDate.map(value => value),
        creationDate.map(value => value),
        cloneUrlHttp.map(value => value),
        cloneUrlSsh.map(value => value),
        arn.map(value => value)
      )
    def accountId: Option[AccountId]
    def repositoryId: Option[RepositoryId]
    def repositoryName: Option[RepositoryName]
    def repositoryDescription: Option[RepositoryDescription]
    def defaultBranch: Option[BranchName]
    def lastModifiedDate: Option[LastModifiedDate]
    def creationDate: Option[CreationDate]
    def cloneUrlHttp: Option[CloneUrlHttp]
    def cloneUrlSsh: Option[CloneUrlSsh]
    def arn: Option[Arn]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRepositoryId: ZIO[Any, AwsError, RepositoryId] =
      AwsError.unwrapOptionField("repositoryId", repositoryId)
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getRepositoryDescription: ZIO[Any, AwsError, RepositoryDescription] =
      AwsError.unwrapOptionField("repositoryDescription", repositoryDescription)
    def getDefaultBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("defaultBranch", defaultBranch)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCloneUrlHttp: ZIO[Any, AwsError, CloneUrlHttp] =
      AwsError.unwrapOptionField("cloneUrlHttp", cloneUrlHttp)
    def getCloneUrlSsh: ZIO[Any, AwsError, CloneUrlSsh] =
      AwsError.unwrapOptionField("cloneUrlSsh", cloneUrlSsh)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ) extends zio.aws.codecommit.model.RepositoryMetadata.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.codecommit.model.primitives.AccountId(value))
    override val repositoryId: Option[RepositoryId] = scala
      .Option(impl.repositoryId())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryId(value))
    override val repositoryName: Option[RepositoryName] = scala
      .Option(impl.repositoryName())
      .map(value => zio.aws.codecommit.model.primitives.RepositoryName(value))
    override val repositoryDescription: Option[RepositoryDescription] = scala
      .Option(impl.repositoryDescription())
      .map(value =>
        zio.aws.codecommit.model.primitives.RepositoryDescription(value)
      )
    override val defaultBranch: Option[BranchName] = scala
      .Option(impl.defaultBranch())
      .map(value => zio.aws.codecommit.model.primitives.BranchName(value))
    override val lastModifiedDate: Option[LastModifiedDate] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.codecommit.model.primitives.LastModifiedDate(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val cloneUrlHttp: Option[CloneUrlHttp] = scala
      .Option(impl.cloneUrlHttp())
      .map(value => zio.aws.codecommit.model.primitives.CloneUrlHttp(value))
    override val cloneUrlSsh: Option[CloneUrlSsh] = scala
      .Option(impl.cloneUrlSsh())
      .map(value => zio.aws.codecommit.model.primitives.CloneUrlSsh(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryMetadata
  ): zio.aws.codecommit.model.RepositoryMetadata.ReadOnly = new Wrapper(impl)
}
