package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Date, Email, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserInfo(
    name: Option[Name] = None,
    email: Option[Email] = None,
    date: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.UserInfo = {
    import UserInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.UserInfo
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(date.map(value => Date.unwrap(value): java.lang.String))(
        _.date
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.UserInfo.ReadOnly =
    zio.aws.codecommit.model.UserInfo.wrap(buildAwsValue())
}
object UserInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.UserInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.UserInfo =
      zio.aws.codecommit.model.UserInfo(
        name.map(value => value),
        email.map(value => value),
        date.map(value => value)
      )
    def name: Option[Name]
    def email: Option[Email]
    def date: Option[Date]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.UserInfo
  ) extends zio.aws.codecommit.model.UserInfo.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val date: Option[Date] = scala
      .Option(impl.date())
      .map(value => zio.aws.codecommit.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.UserInfo
  ): zio.aws.codecommit.model.UserInfo.ReadOnly = new Wrapper(impl)
}
