package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{Mode, Path, ObjectId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BlobMetadata(
    blobId: Option[ObjectId] = None,
    path: Option[Path] = None,
    mode: Option[Mode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.BlobMetadata = {
    import BlobMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.BlobMetadata
      .builder()
      .optionallyWith(
        blobId.map(value => ObjectId.unwrap(value): java.lang.String)
      )(_.blobId)
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(mode.map(value => Mode.unwrap(value): java.lang.String))(
        _.mode
      )
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.BlobMetadata.ReadOnly =
    zio.aws.codecommit.model.BlobMetadata.wrap(buildAwsValue())
}
object BlobMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.BlobMetadata =
      zio.aws.codecommit.model.BlobMetadata(
        blobId.map(value => value),
        path.map(value => value),
        mode.map(value => value)
      )
    def blobId: Option[ObjectId]
    def path: Option[Path]
    def mode: Option[Mode]
    def getBlobId: ZIO[Any, AwsError, ObjectId] =
      AwsError.unwrapOptionField("blobId", blobId)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getMode: ZIO[Any, AwsError, Mode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ) extends zio.aws.codecommit.model.BlobMetadata.ReadOnly {
    override val blobId: Option[ObjectId] = scala
      .Option(impl.blobId())
      .map(value => zio.aws.codecommit.model.primitives.ObjectId(value))
    override val path: Option[Path] = scala
      .Option(impl.path())
      .map(value => zio.aws.codecommit.model.primitives.Path(value))
    override val mode: Option[Mode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.codecommit.model.primitives.Mode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.BlobMetadata
  ): zio.aws.codecommit.model.BlobMetadata.ReadOnly = new Wrapper(impl)
}
