package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  BranchName,
  RepositoryTriggerCustomData,
  Arn,
  RepositoryTriggerName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RepositoryTrigger(
    name: RepositoryTriggerName,
    destinationArn: Arn,
    customData: Option[RepositoryTriggerCustomData] = None,
    branches: Option[Iterable[BranchName]] = None,
    events: Iterable[zio.aws.codecommit.model.RepositoryTriggerEventEnum]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.RepositoryTrigger = {
    import RepositoryTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.RepositoryTrigger
      .builder()
      .name(RepositoryTriggerName.unwrap(name): java.lang.String)
      .destinationArn(Arn.unwrap(destinationArn): java.lang.String)
      .optionallyWith(
        customData.map(value =>
          RepositoryTriggerCustomData.unwrap(value): java.lang.String
        )
      )(_.customData)
      .optionallyWith(
        branches.map(value =>
          value.map { item =>
            BranchName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.branches)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.RepositoryTrigger.ReadOnly =
    zio.aws.codecommit.model.RepositoryTrigger.wrap(buildAwsValue())
}
object RepositoryTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.RepositoryTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.RepositoryTrigger =
      zio.aws.codecommit.model.RepositoryTrigger(
        name,
        destinationArn,
        customData.map(value => value),
        branches.map(value => value),
        events
      )
    def name: RepositoryTriggerName
    def destinationArn: Arn
    def customData: Option[RepositoryTriggerCustomData]
    def branches: Option[List[BranchName]]
    def events: List[zio.aws.codecommit.model.RepositoryTriggerEventEnum]
    def getName: ZIO[Any, Nothing, RepositoryTriggerName] = ZIO.succeed(name)
    def getDestinationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(destinationArn)
    def getCustomData: ZIO[Any, AwsError, RepositoryTriggerCustomData] =
      AwsError.unwrapOptionField("customData", customData)
    def getBranches: ZIO[Any, AwsError, List[BranchName]] =
      AwsError.unwrapOptionField("branches", branches)
    def getEvents: ZIO[Any, Nothing, List[
      zio.aws.codecommit.model.RepositoryTriggerEventEnum
    ]] = ZIO.succeed(events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryTrigger
  ) extends zio.aws.codecommit.model.RepositoryTrigger.ReadOnly {
    override val name: RepositoryTriggerName =
      zio.aws.codecommit.model.primitives.RepositoryTriggerName(impl.name())
    override val destinationArn: Arn =
      zio.aws.codecommit.model.primitives.Arn(impl.destinationArn())
    override val customData: Option[RepositoryTriggerCustomData] = scala
      .Option(impl.customData())
      .map(value =>
        zio.aws.codecommit.model.primitives.RepositoryTriggerCustomData(value)
      )
    override val branches: Option[List[BranchName]] = scala
      .Option(impl.branches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.BranchName(item)
        }.toList
      )
    override val events
        : List[zio.aws.codecommit.model.RepositoryTriggerEventEnum] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.codecommit.model.RepositoryTriggerEventEnum.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.RepositoryTrigger
  ): zio.aws.codecommit.model.RepositoryTrigger.ReadOnly = new Wrapper(impl)
}
